﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
		<title>Kontrola kręgu kosztów</title>
		<meta http-equiv="Content-Type" content="text/html; charset=unicode">
		<script runat="server">
    void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args) {
			KontrolerDekretu kd = (KontrolerDekretu)args.Row;
			colDekret.EditValue = kd.Dekret.Numer.NumerPelny;
			colEwidencja.EditValue = kd.Dekret.Ewidencja.Numer.NumerPelny;
			colWinien.EditValue = kd.Winien.Value;			
			colMa.EditValue = kd.Ma.Value;						
			colSaldo.EditValue = kd.Saldo.Value;									
    }
    
    
    void KontrolaKreguKosztow_OnLoad(Object sender, EventArgs args){
      OkresObrachunkowy okres = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
      StronaKsiegowania stronaRozliczenia;
      StronaKsiegowania stronaKregu;
      if (param.Tryb == Tryb.KrągKosztów)
      {
          stronaRozliczenia = StronaKsiegowania.Ma;
          stronaKregu = StronaKsiegowania.Winien;
      }
      else
      {
          stronaRozliczenia = StronaKsiegowania.Winien;
          stronaKregu = StronaKsiegowania.Ma;          
      }
      
     Soneta.Business.View view = KsiegaModule.GetInstance(DataContext1.Session).ZapisyKsiegowe.WgDekret.CreateView();
			view.Condition = new FieldCondition.Equal("Okres",okres);			
			view.Condition &= new FieldCondition.GreaterEqual("Data",param.Okres.From);			
			view.Condition &= new FieldCondition.LessEqual("Data",param.Okres.To);						
			view.Condition &= new FieldCondition.Equal("TypDziennika",TypDziennika.Dekret);
			
			RowCondition wyjatki = RowCondition.Empty;
			if(param.WyjatkiKosztow!=""){
				string[] konta = param.WyjatkiKosztow.Split(';');
				foreach(string symb in konta){
					string s = symb.Trim();
					if(s=="")
						continue;
					wyjatki &= new FieldCondition.Not(new FieldCondition.Like("Konto.Symbol",s));
				}
			}
			
      view.Condition &= (new FieldCondition.Like("Konto.Symbol",param.KontoRozliczenia) & new FieldCondition.Equal("Strona",stronaRozliczenia)) |
			/*view.Condition |= */(new FieldCondition.Like("Konto.Symbol",param.KontaKosztow) & wyjatki & new FieldCondition.Equal("Strona",stronaKregu));
			
			
			
			ReportHeader1.Title = string.Format("Kontrola kręgu {1} | Za okres: {0}",param.Okres,(param.Tryb==Tryb.KrągKosztów) ? "kosztów" : "przychodów");
			if(param.WyjatkiKosztow!="")
				ReportHeader1.Title += string.Format("| Wyjątki kont kręgu: {0}",param.WyjatkiKosztow);
			if(param.BezKont!="")
				ReportHeader1.Title += string.Format("| Bez kont: {0}",param.BezKont);
			Grid1.Columns[2].Caption = string.Format("Winien ({0})",param.KontaKosztow);
			Grid1.Columns[3].Caption = string.Format("Ma ({0})",param.KontoRozliczenia);			

			Hashtable ht = new Hashtable();
			foreach(ZapisKsiegowy zk in view){
				KontrolerDekretu kd = (KontrolerDekretu)ht[zk.Dekret];
				if(kd==null){
					kd = new KontrolerDekretu((Dekret)zk.Dekret);
					ht[zk.Dekret] = kd;
				}
				kd.Add(zk);
			}
			
			if(param.BezKont!=""){
				view.Condition = new FieldCondition.Equal("Okres",okres);			
				view.Condition &= new FieldCondition.GreaterEqual("Data",param.Okres.From);			
				view.Condition &= new FieldCondition.LessEqual("Data",param.Okres.To);						
				view.Condition &= new FieldCondition.Equal("TypDziennika",TypDziennika.Dekret);
				view.Condition &= (new FieldCondition.Like("Konto.Symbol",param.BezKont) & new FieldCondition.Equal("Strona",stronaKregu));         			
				foreach(ZapisKsiegowy zk in view){
					KontrolerDekretu kd = (KontrolerDekretu)ht[zk.Dekret];
					if(kd!=null)
						ht.Remove(zk.Dekret);
				}				
			}
			
			if(param.TylkoPodejrzane){
				ArrayList arr = new ArrayList();
				foreach(KontrolerDekretu kd in ht.Values)
					if(kd.Saldo.Value!=0m)
						arr.Add(kd);
				Grid1.DataSource = arr;
			}
			else
				Grid1.DataSource = ht.Values;
			
    }
    
    public class KontrolerDekretu{
			public readonly Dekret dekret;
			internal KontrolerDekretu(Dekret dekret){
				this.dekret = dekret;
			}
			
			public Dekret Dekret{
				get{ return dekret; }
			}
			
			Currency winien,ma;
			public Currency Winien{
				get{ return winien; }
			}
			
			public Currency Ma{
				get{ return ma; }
			}
			
			public Currency Saldo{
				get{ return winien - ma; }
			}
			
			internal void Add(ZapisKsiegowy zapis){
				if(zapis.Strona==StronaKsiegowania.Ma)
					ma += zapis.KwotaZapisu;
				if(zapis.Strona==StronaKsiegowania.Winien)
					winien += zapis.KwotaZapisu;
			}
    }
    
    Param param = null;
    
    [Context]
    [Required]
    public Param Params{
			get{ return param; }			
			set{ param = value; }
    }
    
    public enum Tryb{
			KrągKosztów,
			KrągPrzychodów,
    }
    
    public class Param : ContextBase{
			FromTo okres = Date.Today.ToYearMonth().ToFromTo();
			bool tylkoPodejrzane = true;
			Tryb tryb;
			 
			public Param(Context cx): base(cx){
				Dziennik.Params p = (Dziennik.Params)cx[typeof(Dziennik.Params)];
				okres = p.Zakres;
			}
			
			[Caption("Tryb")]
			[Soneta.Tools.Priority(0)]			
			public Tryb Tryb{
				get{ return tryb; }
				set{ tryb = value; OnChanged(EventArgs.Empty); }
			}			
			
			[Caption("Za okres")]
			[Soneta.Tools.Priority(1)]			
			public FromTo Okres{
				get{ return okres; }
				set{ 
					if(value == FromTo.Empty)
						value = FromTo.All;
					okres = value; 
					OnChanged(EventArgs.Empty); 
				}
			}
			
			[Soneta.Tools.Priority(2)]						
			[Caption("Tylko podejrzane")]
			public bool TylkoPodejrzane{
				get{ return tylkoPodejrzane; }
				set{ tylkoPodejrzane = value; OnChanged(EventArgs.Empty); }
			}
			
			
			string kontaKosztow = "4*";
			[Soneta.Tools.Priority(3)]						
			[Caption("Konta kręgu")]
			public string KontaKosztow{
				get{ return kontaKosztow; }
				set{ kontaKosztow = value; OnChanged(EventArgs.Empty); }
			}
			
			string wyjatkiKosztow = "";
			[Soneta.Tools.Priority(4)]						
			[Caption("Wyjątki kont kręgu")]
			public string WyjatkiKosztow{
				get{ return wyjatkiKosztow; }
				set{ wyjatkiKosztow = value; OnChanged(EventArgs.Empty); }
			}			

			string kontoRozliczenia = "490";
			[Soneta.Tools.Priority(5)]						
			[Caption("Konto rozliczenia")]
			public string KontoRozliczenia{
				get{ return kontoRozliczenia; }
				set{ kontoRozliczenia = value; OnChanged(EventArgs.Empty); }
			}			
			
			string bezKont = "";
			[Soneta.Tools.Priority(6)]						
			[Caption("Bez kont")]
			public string BezKont{
				get{ return bezKont; }
				set{ bezKont = value; OnChanged(EventArgs.Empty); }
			}			
    
    }
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
  </HEAD>
	<body>
		<form id="KontrolaKreguKosztow" method="post" runat="server" onload="KontrolaKreguKosztow_OnLoad">
			<P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Ksiega.OkresObrachunkowy, Soneta.Ksiega"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="Kontrola kręgu kosztów" runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_OnBeforeRow" ShowPrevAgrSum="InFooter"
					ShowAgrSum="True" ShowPageSum="True">
<Columns>
<ea:GridColumn Caption="Ewidencja" ID="colEwidencja"></ea:GridColumn>
<ea:GridColumn Caption="Dekret" ID="colDekret"></ea:GridColumn>
<ea:GridColumn Align="Right" Caption="Winien (4*)" Format="{0:n}" ID="colWinien"></ea:GridColumn>
<ea:GridColumn Align="Right" Caption="Ma (490)" Format="{0:n}" ID="colMa"></ea:GridColumn>
<ea:GridColumn Align="Right" Caption="Saldo" Format="{0:n}" ID="colSaldo"></ea:GridColumn>
</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

